<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Feedback;
use App\Models\Content;

class FeedbackSeeder extends Seeder
{
    public function run()
    {
        // Hapus semua feedback lama
        Feedback::truncate();

        $contents = Content::pluck('id');
        foreach ($contents as $contentId) {
            Feedback::create([
                'content_id' => $contentId,
                'feedback' => 'Feedback dummy untuk content ID ' . $contentId,
            ]);
        }
    }
} 