@extends('layouts.dashboard')

@section('content')
<div class="container-fluid px-2 px-md-4 py-4">
    <div class="row justify-content-center">
        <div class="col-12 col-md-10 col-lg-8 mx-auto">
            <div class="card shadow-sm" style="border-radius: 1rem;">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="fas fa-plus-circle me-2"></i>
                        Tambah Contoh Baru
                    </h5>
                    @if($content_id)
                    <a href="{{ route('content.show', $content_id) }}" class="btn btn-secondary btn-sm">Kembali ke Konten</a>
                    @endif
                </div>
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('contoh.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @if($content_id)
                        <input type="hidden" name="content_id" value="{{ $content_id }}">
                        @endif
                        <!-- Nama Contoh -->
                        <div class="mb-3">
                            <label for="nama" class="form-label">
                                <i class="fas fa-tag me-1"></i>
                                Nama Contoh <span class="text-danger">*</span>
                            </label>
                            <input type="text" 
                                   class="form-control @error('nama') is-invalid @enderror" 
                                   id="nama" 
                                   name="nama" 
                                   value="{{ old('nama') }}"
                                   placeholder="Masukkan nama contoh..."
                                   required>
                            @error('nama')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <!-- Fokus Utama -->
                        <div class="mb-3">
                            <label for="fokus_utama" class="form-label">Fokus Utama <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('fokus_utama') is-invalid @enderror" id="fokus_utama" name="fokus_utama" value="{{ old('fokus_utama') }}" placeholder="Masukkan fokus utama..." required>
                            @error('fokus_utama')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <!-- Aspek Unik -->
                        <div class="mb-3">
                            <label for="aspek_unik" class="form-label">Aspek Unik <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('aspek_unik') is-invalid @enderror" id="aspek_unik" name="aspek_unik" value="{{ old('aspek_unik') }}" placeholder="Masukkan aspek unik..." required>
                            @error('aspek_unik')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <!-- Isi -->
                        <div class="mb-3">
                            <label for="isi" class="form-label">Isi <span class="text-danger">*</span></label>
                            <textarea name="isi" id="isi" class="form-control @error('isi') is-invalid @enderror" rows="10">{{ old('isi') }}</textarea>
                            @error('isi')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <!-- Action Buttons -->
                        <div class="d-flex justify-content-between">
                            <button type="button" class="btn btn-secondary" onclick="history.back()">
                                <i class="fas fa-times me-1"></i>
                                Batal
                            </button>
                            <div>
                                <button type="reset" class="btn btn-warning me-2">
                                    <i class="fas fa-undo me-1"></i>
                                    Reset
                                </button>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-1"></i>
                                    Simpan Contoh
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/tinymce@6.8.3/tinymce.min.js"></script>
<script>
  tinymce.init({
    selector: '#isi',
    height: 600,
    menubar: true,
    plugins: 'lists link image table code media',
    toolbar: 'undo redo | styles | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media table | code | customImage customVideo',
    setup: function(editor) {
      editor.ui.registry.addButton('customImage', {
        text: '',
        icon: 'image',
        tooltip: 'Upload & Insert Image',
        onAction: function() {
          openCustomImageModal(editor);
        }
      });
      editor.ui.registry.addButton('customVideo', {
        text: '',
        icon: 'media',
        tooltip: 'Upload & Insert Video',
        onAction: function() {
          openCustomVideoModal(editor);
        }
      });
    }
  });

  function openCustomImageModal(editor) {
    var modal = document.createElement('div');
    modal.style.position = 'fixed';
    modal.style.top = '0';
    modal.style.left = '0';
    modal.style.width = '100vw';
    modal.style.height = '100vh';
    modal.style.background = 'rgba(0,0,0,0.5)';
    modal.style.display = 'flex';
    modal.style.alignItems = 'center';
    modal.style.justifyContent = 'center';
    modal.style.zIndex = '9999';
    modal.innerHTML = `
      <div style=\"background:#fff;padding:24px;border-radius:8px;min-width:320px;max-width:90vw;text-align:center;\">
        <h5>Upload & Preview Image</h5>
        <input type=\"file\" id=\"customImageInput\" accept=\"image/*\" style=\"margin-bottom:12px;\" />
        <div id=\"customImagePreview\" style=\"margin-bottom:12px;\"></div>
        <button id=\"customImageInsert\" class=\"btn btn-primary\" disabled>Insert</button>
        <button id=\"customImageCancel\" class=\"btn btn-secondary\" style=\"margin-left:8px;\">Cancel</button>
      </div>
    `;
    document.body.appendChild(modal);

    var input = modal.querySelector('#customImageInput');
    var preview = modal.querySelector('#customImagePreview');
    var insertBtn = modal.querySelector('#customImageInsert');
    var cancelBtn = modal.querySelector('#customImageCancel');
    var imageData = '';

    input.addEventListener('change', function() {
      var file = this.files[0];
      if (file) {
        var reader = new FileReader();
        reader.onload = function(e) {
          imageData = e.target.result;
          preview.innerHTML = `<img src=\"${imageData}\" style=\"max-width:200px;max-height:200px;\" />`;
          insertBtn.disabled = false;
        };
        reader.readAsDataURL(file);
      }
    });

    insertBtn.addEventListener('click', function() {
      if (imageData) {
        editor.insertContent(`<img src='${imageData}' style='max-width:100%;height:auto;' />`);
        document.body.removeChild(modal);
      }
    });
    cancelBtn.addEventListener('click', function() {
      document.body.removeChild(modal);
    });
  }

  function openCustomVideoModal(editor) {
    var modal = document.createElement('div');
    modal.style.position = 'fixed';
    modal.style.top = '0';
    modal.style.left = '0';
    modal.style.width = '100vw';
    modal.style.height = '100vh';
    modal.style.background = 'rgba(0,0,0,0.5)';
    modal.style.display = 'flex';
    modal.style.alignItems = 'center';
    modal.style.justifyContent = 'center';
    modal.style.zIndex = '9999';
    modal.innerHTML = `
      <div style=\"background:#fff;padding:24px;border-radius:8px;min-width:320px;max-width:90vw;text-align:center;\">
        <h5>Upload & Preview Video</h5>
        <input type=\"file\" id=\"customVideoInput\" accept=\"video/mp4,video/webm,video/ogg\" style=\"margin-bottom:12px;\" />
        <div id=\"customVideoPreview\" style=\"margin-bottom:12px;\"></div>
        <button id=\"customVideoInsert\" class=\"btn btn-primary\" disabled>Insert</button>
        <button id=\"customVideoCancel\" class=\"btn btn-secondary\" style=\"margin-left:8px;\">Cancel</button>
      </div>
    `;
    document.body.appendChild(modal);

    var input = modal.querySelector('#customVideoInput');
    var preview = modal.querySelector('#customVideoPreview');
    var insertBtn = modal.querySelector('#customVideoInsert');
    var cancelBtn = modal.querySelector('#customVideoCancel');
    var videoData = '';

    input.addEventListener('change', function() {
      var file = this.files[0];
      if (file) {
        var reader = new FileReader();
        reader.onload = function(e) {
          videoData = e.target.result;
          preview.innerHTML = `<video src=\"${videoData}\" controls style=\"max-width:300px;max-height:200px;\"></video>`;
          insertBtn.disabled = false;
        };
        reader.readAsDataURL(file);
      }
    });

    insertBtn.addEventListener('click', function() {
      if (videoData) {
        editor.insertContent(`<video src='${videoData}' controls style='max-width:100%;height:auto;'></video>`);
        document.body.removeChild(modal);
      }
    });
    cancelBtn.addEventListener('click', function() {
      document.body.removeChild(modal);
    });
  }
</script>
<style>
    .card {
        border: none;
        border-radius: 0.5rem;
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    }
    .card-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 0.5rem 0.5rem 0 0 !important;
    }
    .form-label {
        font-weight: 600;
        color: #495057;
    }
    .form-control:focus {
        border-color: #667eea;
        box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
    }
    .btn-primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border: none;
        border-radius: 0.375rem;
        padding: 0.5rem 1.5rem;
        font-weight: 600;
        transition: all 0.3s ease;
    }
    .btn-primary:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 8px rgba(102, 126, 234, 0.3);
    }
    .btn-secondary {
        background: #6c757d;
        border: none;
        border-radius: 0.375rem;
        padding: 0.5rem 1.5rem;
        font-weight: 600;
        transition: all 0.3s ease;
    }
    .btn-warning {
        background: #ffc107;
        border: none;
        border-radius: 0.375rem;
        padding: 0.5rem 1.5rem;
        font-weight: 600;
        transition: all 0.3s ease;
        color: #212529;
    }
    .btn:hover {
        transform: translateY(-1px);
    }
    .form-text {
        color: #6c757d;
        font-size: 0.875rem;
    }
    .text-danger {
        color: #dc3545 !important;
    }
    .invalid-feedback {
        display: block;
        color: #dc3545;
        font-size: 0.875rem;
        margin-top: 0.25rem;
    }
    .is-invalid {
        border-color: #dc3545;
    }
    .is-invalid:focus {
        border-color: #dc3545;
        box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25);
    }
    /* TinyMCE Customization */
    .tox-tinymce {
        border-radius: 0.375rem;
        border: 1px solid #ced4da;
    }
    .tox-tinymce:focus-within {
        border-color: #667eea;
        box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
    }
</style>
@endsection
