
<?php $__env->startSection('content'); ?>
<div class="container">
    <h2>Daftar Menu</h2>
    <a href="<?php echo e(route('menus.create')); ?>" class="btn btn-primary mb-3">Tambah Menu</a>
    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>#</th>
                <th>Nama</th>
                <th>Icon</th>
                <th>Deskripsi</th>
                <th>Urutan</th>
                <th>Status</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($loop->iteration); ?></td>
                <td><?php echo e($menu->name); ?></td>
                <td><span class="material-icons"><?php echo e($menu->icon); ?></span></td>
                <td><?php echo e($menu->description); ?></td>
                <td><?php echo e($menu->order); ?></td>
                <td><?php echo e($menu->status ? 'Aktif' : 'Nonaktif'); ?></td>
                <td>
                    <div style="display: flex; gap: 4px; align-items: center;">
                        <a href="<?php echo e(route('menu.contents', $menu)); ?>" class="btn btn-sm btn-success" title="Lihat Konten" style="padding: 4px 7px;"><i class="fas fa-list"></i></a>
                        <a href="<?php echo e(route('menus.show', $menu)); ?>" class="btn btn-sm btn-info" title="Lihat" style="padding: 4px 7px;"><i class="fas fa-eye"></i></a>
                        <a href="<?php echo e(route('menus.edit', $menu)); ?>" class="btn btn-sm btn-warning" title="Edit" style="padding: 4px 7px;"><i class="fas fa-pen"></i></a>
                        <form action="<?php echo e(route('menus.destroy', $menu)); ?>" method="POST" style="display:inline; margin:0;">
                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-danger" title="Hapus" style="padding: 4px 7px;" onclick="return confirm('Yakin hapus?')"><i class="fas fa-trash"></i></button>
                        </form>
                    </div>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/rama3823/public_html/tisel/resources/views/menu/index.blade.php ENDPATH**/ ?>