<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Home - TISEL</title>
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', Arial, sans-serif;
            background: #fff;
        }
        .header {
            background: linear-gradient(135deg,rgb(212, 138, 0) 0%,rgb(247, 195, 27) 100%);
            border-bottom-left-radius: 40px;
            border-bottom-right-radius: 40px;
            padding: 32px 0 80px 0;
            position: relative;
        }
        .header-content {
            max-width: 500px;
            margin: 0 auto;
            color: #fff;
            padding-left: 24px;
        }
        .header .login-btn {
            position: absolute;
            top: 24px;
            right: 32px;
            background: #fff;
            color: #ff9800;
            border: none;
            border-radius: 20px;
            padding: 8px 24px;
            font-size: 16px;
            font-weight: 500;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
            cursor: pointer;
        }
        .header .login-btn:hover {
            background: #ffe0b2;
        }
        .welcome {
            font-size: 22px;
            margin-bottom: 8px;
        }
        .login-title {
            font-size: 25px;
            font-weight: bold;
            margin-bottom: 0;
        }
        .main-card {
            background:rgb(19, 1, 34); /* kuning muda */
            border-radius: 32px;
            box-shadow: 0 4px 24px rgb(237, 245, 123);
            margin: -80px 8px 16px 8px; /* dinaikkan lebih dekat ke header */
            padding: 20px 8px 16px 8px;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        .logos {
            display: flex;
            gap: 8px; /* lebih rapat */
            margin-bottom: 4px; /* lebih rapat */
        }
        .logos img {
            width: 48px;
            height: 48px;
            border-radius: 12px;
            background:rgba(112, 86, 10, 0); /* kuning muda */
            object-fit: contain;
        }
        .tisel-title {
            font-size: 28px; /* sedikit lebih kecil agar proporsional */
            font-weight: bold;
            color: #ff9800;
            margin-left: 8px; /* lebih rapat */
            display: inline-block;
            vertical-align: middle;
        }
        .desc {
            color: #fff;
            background:rgba(51, 18, 172, 0);
            border-radius: 16px;
            padding: 8px 8px;
            font-size: 15px;
            font-weight: 500;
            text-align: center;
            margin-top: 8px;
            border: none;
            box-shadow: none;
        }
        .section-title {
            font-size: 20px;
            font-weight: bold;
            margin: 32px 0 8px 16px;
        }
        .error-message {
            color: #888;
            text-align: center;
            margin-top: 16px;
            font-size: 16px;
        }
        .feature-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
            gap: 20px;
            margin: 32px 16px 0 16px;
        }
        .feature-card {
            background:rgba(247, 247, 247, 0.45);
            border-radius: 14px;
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 12px 0 8px 0;
            box-shadow: 0 2px 8px rgba(0,0,0,0.04);
            position: relative;
        }
        .feature-icon {
            width: 64px;
            height: 64px;
            object-fit: cover;
            border-radius: 50%;
            background: #fff;
            margin-bottom: 12px;
            display: block;
            border: 2px solid #eee;
            box-shadow: 0 2px 8px rgba(0,0,0,0.06);
        }
        .feature-label {
            font-size: 13px;
            color: #444;
            font-weight: 500;
            text-align: center;
        }
        .menu-action-btn {
            width: 22px;
            height: 22px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 11px;
            border: none;
            outline: none;
            box-shadow: 0 1px 4px rgba(0,0,0,0.08);
            position: absolute;
            top: 8px;
            z-index: 10;
            opacity: 0;
            transition: opacity 0.2s;
            cursor: pointer;
            padding: 0;
        }
        .btn-edit-menu.menu-action-btn {
            right: 34px;
            background: #ff9800;
            color: #fff;
        }
        .btn-delete-menu.menu-action-btn {
            right: 8px;
            background: #e53935;
            color: #fff;
        }
        .feature-card:hover .menu-action-btn,
        .feature-card:focus-within .menu-action-btn {
            opacity: 1;
        }
        @media (hover: none) and (pointer: coarse) {
            .feature-card:active .menu-action-btn {
                opacity: 1;
            }
        }
        .menu-action-group {
            display: flex;
            gap: 6px;
            justify-content: center;
            margin-top: 6px;
            position: relative;
            z-index: 3;
            opacity: 0;
            transition: opacity 0.2s;
            pointer-events: none;
        }
        .feature-card:hover .menu-action-group,
        .feature-card:focus-within .menu-action-group {
            opacity: 1;
            pointer-events: auto;
        }
        @media (hover: none) and (pointer: coarse) {
            .feature-card:active .menu-action-group {
                opacity: 1;
                pointer-events: auto;
            }
        }
        @media (max-width: 600px) {
            .main-card {
                margin: -60px 4vw 24px 4vw;
                padding: 24px 4vw 16px 4vw;
            }
            .section-title {
                margin-left: 4vw;
            }
            .feature-grid {
                grid-template-columns: repeat(3, 1fr);
                gap: 10px;
            }
            .feature-card {
                padding: 8px 0 6px 0;
                border-radius: 10px;
            }
            .feature-icon {
                width: 28px;
                height: 28px;
                border-radius: 6px;
                margin-bottom: 4px;
            }
            .feature-label {
                font-size: 11px;
            }
        }
    </style>
    
</head>
<body>
    <?php if(session('success')): ?>
        <div style="background:#d4edda; color:#155724; border-radius:8px; padding:10px 18px; margin:16px;">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    <div class="header">
        <?php if(auth()->check()): ?>
            <div style="position:absolute; top:24px; right:32px; display:flex; align-items:center; gap:12px; z-index:10;">
                <div class="user-dropdown" style="position:relative;">
                    <button onclick="document.getElementById('userDropdownMenu').classList.toggle('show');" style="display:flex; align-items:center; background:transparent; border:none; cursor:pointer; padding:0; gap:10px;">
                        <?php $profile = auth()->user()->profile; ?>
                        <?php if($profile && $profile->foto_profile): ?>
                            <img src="<?php echo e(asset('storage/' . $profile->foto_profile)); ?>" alt="Foto Profil" style="width:36px; height:36px; border-radius:50%; object-fit:cover; border:2px solid #fff; background:#eee;">
                        <?php else: ?>
                            <img src="/icon/default_profile.png" alt="Default Profile" style="width:36px; height:36px; border-radius:50%; object-fit:cover; border:2px solid #fff; background:#eee;">
                        <?php endif; ?>
                    </button>
                    <div id="userDropdownMenu" class="user-dropdown-menu" style="display:none; position:absolute; right:0; top:110%; background:#fff; border-radius:10px; box-shadow:0 2px 12px rgba(0,0,0,0.12); min-width:160px; overflow:hidden;">
                        <a href="<?php echo e(route('dashboard')); ?>" style="display:block; padding:10px 18px; color:#333; text-decoration:none; font-size:15px;">Dashboard</a>
                        <a href="<?php echo e(route('profile')); ?>" style="display:block; padding:10px 18px; color:#333; text-decoration:none; font-size:15px;">Profile</a>
                        <form action="<?php echo e(route('logout')); ?>" method="POST" style="margin:0;">
                            <?php echo csrf_field(); ?>
                            <button type="submit" style="width:100%; text-align:left; background:none; border:none; padding:10px 18px; color:#e53935; font-size:15px; cursor:pointer;">Logout</button>
                        </form>
                    </div>
                </div>
            </div>
            <script>
                // Close dropdown jika klik di luar
                document.addEventListener('click', function(event) {
                    var dropdown = document.getElementById('userDropdownMenu');
                    if (!event.target.closest('.user-dropdown')) {
                        dropdown && dropdown.classList.remove('show');
                    }
                });
            </script>
            <style>
                .user-dropdown-menu { display:none; }
                .user-dropdown-menu.show { display:block !important; }
                .user-dropdown-menu a:hover, .user-dropdown-menu button:hover { background:#f5f5f5; }
            </style>
        <?php else: ?>
            <a href="<?php echo e(route('login')); ?>" class="login-btn" style="position:absolute; top:24px; right:32px; background:#fff; color:#ff9800; border:none; border-radius:20px; padding:8px 24px; font-size:16px; font-weight:500; box-shadow:0 2px 8px rgba(0,0,0,0.08); cursor:pointer; text-decoration:none;">Login</a>
        <?php endif; ?>
        <div class="header-content">
            <div class="welcome">Welcome</div>
            <div class="login-title">
                <?php if(auth()->check()): ?>
                    Halo, <?php echo e(auth()->user()->name); ?>

                <?php else: ?>
                    Silakan login
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="main-card" style="margin-top: -40px; padding-top: 8px; position: relative;">
        <div style="display: flex; align-items: center; gap: 8px; margin-bottom: 4px; margin-top: 8px; justify-content: center;">
            <div class="logos" style="margin-bottom: 0;">
                <img src="/icon/Lambang_baru_UNJ.png" alt="Logo TISEL">
                <img src="/icon/brin.png" alt="Logo TISEL">
                <img src="/icon/lpdp.png" alt="Logo TISEL">
            </div>
            <span class="tisel-title">TISEL</span>
        </div>
        <div class="desc">
            MODEL TEACHING OF INTELLECTUAL SOCIAL EMOTIONAL LEARNING (TISEL) DALAM PENGUATAN KARAKTER PENDIDIK PADA MAHASISWA PROGRAM PENDIDIKAN PROFESI GURU (PPG)
        </div>
    </div>
    <div class="section-title" style="display:flex; align-items:center; gap:12px;">
        Prosedural Model TISEL
        <?php if(auth()->check() && auth()->user()->hasAnyRole(['admin', 'superadmin'])): ?>
            <a href="<?php echo e(route('menus.create')); ?>" style="background:#43a047; color:#fff; border:none; border-radius:6px; display:flex; align-items:center; gap:6px; padding:4px 12px; font-size:15px; text-decoration:none; font-weight:500; margin-left:8px; box-shadow:none;">
                <i class="fas fa-plus"></i> <span>Tambah Menu</span>
            </a>
        <?php endif; ?>
    </div>
    <div class="feature-grid">
        <?php $menus = $menus ?? collect(); ?>
        <?php $__empty_1 = true; $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="feature-card" style="position:relative;">
                <?php if(auth()->check()): ?>
                    <a href="<?php echo e(route('menus.show', $menu)); ?>" style="display:block; width:100%; height:100%; position:absolute; left:0; top:0; z-index:1; pointer-events:auto;"></a>
                <?php else: ?>
                    <div style="display:block; width:100%; height:100%; position:absolute; left:0; top:0; z-index:1; pointer-events:none;"></div>
                <?php endif; ?>
                <div style="position:relative; z-index:2; pointer-events:none; display:flex; flex-direction:column; align-items:center;">
                    <?php if($menu->icon && file_exists(public_path('storage/' . $menu->icon))): ?>
                        <img src="<?php echo e(asset('storage/' . $menu->icon)); ?>" alt="<?php echo e($menu->name); ?>" class="feature-icon" style="pointer-events:none; width:64px; height:64px; border-radius:50%; background:#fff; border:2px solid #eee; margin-bottom:12px; object-fit:cover; box-shadow:0 2px 8px rgba(0,0,0,0.06);" />
                    <?php else: ?>
                        <span class="feature-icon" style="font-size:40px; margin-bottom:12px; pointer-events:none; display:flex; align-items:center; justify-content:center; background:#fff; border-radius:50%; width:64px; height:64px; border:2px solid #eee; box-shadow:0 2px 8px rgba(0,0,0,0.06);">🗂️</span>
                    <?php endif; ?>
                    <div class="feature-label" style="pointer-events:none;"><?php echo e($menu->name); ?></div>
                    <?php if(auth()->check() && auth()->user()->hasAnyRole(['admin', 'superadmin'])): ?>
                        <div class="menu-action-group" style="pointer-events:auto;">
                            <a href="<?php echo e(route('menus.edit', $menu)); ?>" class="btn-edit-menu menu-action-btn" title="Edit" style="position:static; opacity:1; box-shadow:none; pointer-events:auto;">
                                <i class="fas fa-pen"></i>
                            </a>
                            <form action="<?php echo e(route('menus.destroy', $menu)); ?>" method="POST" style="display:inline; position:static; pointer-events:auto;">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn-delete-menu menu-action-btn" title="Delete" style="position:static; opacity:1; box-shadow:none; pointer-events:auto;" onclick="return confirm('Yakin hapus menu ini?')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="error-message" style="width:100%; grid-column:1/-1;">Belum ada menu. <?php if(auth()->check() && auth()->user()->hasAnyRole(['admin', 'superadmin'])): ?> Silakan klik tombol <b>+</b> untuk menambah menu baru. <?php endif; ?></div>
        <?php endif; ?>
    </div>
</body>
</html>
<?php /**PATH /home/rama3823/public_html/tisel/resources/views/home.blade.php ENDPATH**/ ?>