<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card shadow-sm border-0 mt-4">
            <div class="card-header bg-success text-white fw-bold fs-5">
                <?php echo e($method === 'PUT' ? 'Edit Feedback' : 'Beri Feedback'); ?>

            </div>
            <div class="card-body">
                <form action="<?php echo e($action); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php if($method === 'PUT'): ?>
                        <?php echo method_field('PUT'); ?>
                    <?php endif; ?>
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <div class="mb-3">
                        <label for="feedback" class="form-label fw-semibold">Feedback</label>
                        <textarea name="feedback" id="feedback" class="form-control" rows="7"><?php echo e(old('feedback', $feedback->feedback ?? '')); ?></textarea>
                    </div>
                    <?php if($content_id): ?>
                        <input type="hidden" name="content_id" value="<?php echo e($content_id); ?>">
                    <?php endif; ?>
                    <div class="d-flex justify-content-end">
                        <button type="submit" class="btn btn-success px-4 py-2 fw-bold">
                            <span class="material-icons align-middle" style="font-size:18px;vertical-align:middle;">save</span>
                            <?php echo e($method === 'PUT' ? 'Update' : 'Kirim'); ?>

                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/tinymce@6.8.3/tinymce.min.js"></script>
<script>
  tinymce.init({
    selector: '#feedback',
    height: 600,
    menubar: true,
    plugins: 'lists link image table code media',
    toolbar: 'undo redo | styles | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media table | code | customImage customVideo',
    setup: function(editor) {
      editor.ui.registry.addButton('customImage', {
        text: '',
        icon: 'image',
        tooltip: 'Upload & Insert Image',
        onAction: function() {
          openCustomImageModal(editor);
        }
      });
      editor.ui.registry.addButton('customVideo', {
        text: '',
        icon: 'media',
        tooltip: 'Upload & Insert Video',
        onAction: function() {
          openCustomVideoModal(editor);
        }
      });
    }
  });

  function openCustomImageModal(editor) {
    var modal = document.createElement('div');
    modal.style.position = 'fixed';
    modal.style.top = '0';
    modal.style.left = '0';
    modal.style.width = '100vw';
    modal.style.height = '100vh';
    modal.style.background = 'rgba(0,0,0,0.5)';
    modal.style.display = 'flex';
    modal.style.alignItems = 'center';
    modal.style.justifyContent = 'center';
    modal.style.zIndex = '9999';
    modal.innerHTML = `
      <div style="background:#fff;padding:24px;border-radius:8px;min-width:320px;max-width:90vw;text-align:center;">
        <h5>Upload & Preview Image</h5>
        <input type="file" id="customImageInput" accept="image/*" style="margin-bottom:12px;" />
        <div id="customImagePreview" style="margin-bottom:12px;"></div>
        <button id="customImageInsert" class="btn btn-primary" disabled>Insert</button>
        <button id="customImageCancel" class="btn btn-secondary" style="margin-left:8px;">Cancel</button>
      </div>
    `;
    document.body.appendChild(modal);

    var input = modal.querySelector('#customImageInput');
    var preview = modal.querySelector('#customImagePreview');
    var insertBtn = modal.querySelector('#customImageInsert');
    var cancelBtn = modal.querySelector('#customImageCancel');
    var imageData = '';

    input.addEventListener('change', function() {
      var file = this.files[0];
      if (file) {
        var reader = new FileReader();
        reader.onload = function(e) {
          imageData = e.target.result;
          preview.innerHTML = `<img src="${imageData}" style="max-width:200px;max-height:200px;" />`;
          insertBtn.disabled = false;
        };
        reader.readAsDataURL(file);
      }
    });

    insertBtn.addEventListener('click', function() {
      if (imageData) {
        editor.insertContent(`<img src='${imageData}' style='max-width:100%;height:auto;' />`);
        document.body.removeChild(modal);
      }
    });
    cancelBtn.addEventListener('click', function() {
      document.body.removeChild(modal);
    });
  }

  function openCustomVideoModal(editor) {
    var modal = document.createElement('div');
    modal.style.position = 'fixed';
    modal.style.top = '0';
    modal.style.left = '0';
    modal.style.width = '100vw';
    modal.style.height = '100vh';
    modal.style.background = 'rgba(0,0,0,0.5)';
    modal.style.display = 'flex';
    modal.style.alignItems = 'center';
    modal.style.justifyContent = 'center';
    modal.style.zIndex = '9999';
    modal.innerHTML = `
      <div style="background:#fff;padding:24px;border-radius:8px;min-width:320px;max-width:90vw;text-align:center;">
        <h5>Upload & Preview Video</h5>
        <input type="file" id="customVideoInput" accept="video/mp4,video/webm,video/ogg" style="margin-bottom:12px;" />
        <div id="customVideoPreview" style="margin-bottom:12px;"></div>
        <button id="customVideoInsert" class="btn btn-primary" disabled>Insert</button>
        <button id="customVideoCancel" class="btn btn-secondary" style="margin-left:8px;">Cancel</button>
      </div>
    `;
    document.body.appendChild(modal);

    var input = modal.querySelector('#customVideoInput');
    var preview = modal.querySelector('#customVideoPreview');
    var insertBtn = modal.querySelector('#customVideoInsert');
    var cancelBtn = modal.querySelector('#customVideoCancel');
    var videoData = '';

    input.addEventListener('change', function() {
      var file = this.files[0];
      if (file) {
        var reader = new FileReader();
        reader.onload = function(e) {
          videoData = e.target.result;
          preview.innerHTML = `<video src="${videoData}" controls style="max-width:300px;max-height:200px;"></video>`;
          insertBtn.disabled = false;
        };
        reader.readAsDataURL(file);
      }
    });

    insertBtn.addEventListener('click', function() {
      if (videoData) {
        editor.insertContent(`<video src='${videoData}' controls style='max-width:100%;height:auto;'></video>`);
        document.body.removeChild(modal);
      }
    });
    cancelBtn.addEventListener('click', function() {
      document.body.removeChild(modal);
    });
  }
</script> <?php /**PATH /home/rama3823/public_html/tisel/resources/views/feedback/form.blade.php ENDPATH**/ ?>